<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Process extends Model 
{

    protected $table = 'processes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('serial', 'name_ar', 'name_en', 'version_date', 'status', 'notes');

    public function steps()
    {
        return $this->hasMany('App\Models\ProcessStep');
    }

    public function executions()
    {
        return $this->hasMany('App\Models\ProcessExecution');
    }

}